//---------------------------
// UCL-CEREM-MBS
//
// @version MBsysLab_s 1.7.a
//
// Creation : 2006
// Last update : 01/10/2008
//---------------------------

#include "math.h"
#include "user_all_id.h"
#include "mbs_data.h"
#include "user_model.h"


void user_DrivenJoints(MbsData *mbs_data,double tsim)
{
	/*
    double A = 0.2;
    double f = 1;
	UserModel* um = mbs_data->user_model;
	double h = um->Road.height;
	*/

    //mbs_data->q[T3_poster_id]  = -A*cos(2*M_PI*f*tsim) + h;
    //mbs_data->qd[T3_poster_id]  = 2*M_PI*f*A*sin(2*M_PI*f*tsim);
    //mbs_data->qdd[T3_poster_id] = 4*(M_PI*M_PI)*(f*f)*A*cos(2*M_PI*f*tsim);
	
	if(mbs_data->process == 50){
        double rod2_R1_min = -1.1;
        double rod2_R1_max =  1.2;
        double rod2_R1_0   =  mbs_data->q0[R1_chassis_barre2_id];
        
        mbs_data->q[R1_chassis_barre2_id]   = (rod2_R1_min - rod2_R1_0)*tsim +  rod2_R1_0;
        mbs_data->qd[R1_chassis_barre2_id]  = 0.0;
        mbs_data->qdd[R1_chassis_barre2_id] = 0.0;
	}
    
    else if(mbs_data->process == 51){
        double rod2_R1_min = -1.1;
        double rod2_R1_max =  1.2;
        double rod2_R1_0   = mbs_data->q0[R1_chassis_barre2_id];
        
        mbs_data->q[R1_chassis_barre2_id]   = (rod2_R1_max - rod2_R1_min)*tsim +  rod2_R1_min;
        mbs_data->qd[R1_chassis_barre2_id]  = 0.0;
        mbs_data->qdd[R1_chassis_barre2_id] = 0.0;
	}
		
		
	else if(mbs_data->process == 30){
        double Z = -0.1;
               
        if(tsim < 0.2){
            mbs_data->q[T3_poster_id]   = 0.0;
            mbs_data->qd[T3_poster_id]  = 0.0;
            mbs_data->qdd[T3_poster_id] = 0.0;
		}
            
        else{     
            mbs_data->q[T3_poster_id]   = Z;
            mbs_data->qd[T3_poster_id]  = 0.0;
            mbs_data->qdd[T3_poster_id] = 0.0;
			
		}
	}

    else if(mbs_data->process == 31){ 
		double zmax = 0.005;
		double f0 = 1.;
		double t0 = 0.;
		double f1 = 10.;
		double t1 = 10.;

        // Contact forces between wheel-ground are only spring law (no damping) 
        //We only implement the trajectory because forces only depend on the position
		mbs_data->q[T3_poster_id] = zmax * sin(2 * M_PI*(f0 + (f1 - f0) / (t1 - t0)*tsim / 2.0)*tsim);
		mbs_data->qd[T3_poster_id] = 0;
		mbs_data->qdd[T3_poster_id] = 0;
	}
}

 
